% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-chisq-gof-test.R
\name{infer_chisq_gof_test}
\alias{infer_chisq_gof_test}
\alias{chisq_gof}
\title{Chi Square Goodness of Fit Test}
\usage{
infer_chisq_gof_test(x, y, correct = FALSE)
}
\arguments{
\item{x}{categorical variable}

\item{y}{expected proportions}

\item{correct}{logical; if TRUE continuity correction is applied}
}
\value{
\code{infer_chisq_gof_test} returns an object of class
\code{"infer_chisq_gof_test"}. An object of class \code{"infer_chisq_gof_test"}
is a list containing the following components:

\item{chisquare}{chi square statistic}
\item{pvalue}{p-value}
\item{df}{chi square degrees of freedom}
\item{ssize}{number of observations}
\item{names}{levels of \code{x}}
\item{level}{number of levels of \code{x}}
\item{obs}{observed frequency/proportion}
\item{exp}{expected frequency/proportion}
\item{deviation}{deviation of observed from frequency}
\item{std}{standardized residuals}
\item{varname}{name of categorical variable}
}
\description{
Test whether the observed proportions for a categorical variable
differ from hypothesized proportions
}
\section{Deprecated Function}{

\code{chisq_gof()} has been deprecated. Instead use
\code{infer_chisq_gof_test()}
}

\examples{
infer_chisq_gof_test(as.factor(hsb$race), c(20, 20, 20, 140))

# apply continuity correction
infer_chisq_gof_test(as.factor(hsb$race), c(20, 20, 20, 140), correct = TRUE)
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{chisq.test}}
}
