% Generated by roxygen2 (4.0.2): do not edit by hand
\name{political}
\alias{political}
\title{Returns a probability distribution over the political alignment of the speaker}
\usage{
political(text, local.api = FALSE)
}
\arguments{
\item{text}{text for analysis}

\item{local.api}{logical, whether use local or remote API}
}
\value{
List with party probability pairs
}
\description{
Given input text, returns a probability distribution over the political
alignment of the speaker.
}
\examples{
affilation <- political("I am so proud to stand here today
                         as Prime Minister of four nations
                         in one United Kingdom.")
affilation
most.like <- names(affilation[which.max(unlist(affilation))])
least.like <- names(affilation[which.min(unlist(affilation))])
cat(sprintf("This text is most like \%s and least like \%s",
            most.like, least.like))
}
\seealso{
\code{\link{sentiment}}, \code{\link{language}}
}
\keyword{API}
\keyword{analysis}
\keyword{indico.io}
\keyword{learning}
\keyword{machine}
\keyword{political}
\keyword{sentiment}

