% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_test.R
\name{test_diff}
\alias{test_diff}
\title{Test the difference for delay model parameter(s) between two uncorrelated groups, based on maximum product of spacings estimation (MPSE).}
\usage{
test_diff(
  x,
  y = stop("Provide data for group y!"),
  distribution = c("exponential", "weibull"),
  param = "delay",
  R = 400,
  ties = c("density", "equidist", "random", "error"),
  type = c("all", "bootstrap", "gof", "moran", "pearson", "lr", "lr_pp"),
  verbose = 0
)
}
\arguments{
\item{x}{data from reference/control group.}

\item{y}{data from the treatment group.}

\item{distribution}{character(1). Name of the parametric delay distribution to use.}

\item{param}{character. Names of parameters to test difference for. Default value is \code{'delay'}.}

\item{R}{numeric(1). Number of bootstrap samples to evaluate the distribution of the test statistic.}

\item{ties}{character. How to handle ties in data vector of a group?}

\item{type}{character. Which type of tests to perform?}

\item{verbose}{numeric. How many details are requested? Higher value means more details. 0=off, no details.}
}
\value{
list with the results of the test. Element P contains the different P-values, for instance from parametric bootstrap
}
\description{
It is in fact a model comparison between a null model where the parameters are enforced to be equal and an unconstrained full model.
As test statistic we use twice the difference in best (=lowest) objective function value, i.e. 2 * (\code{val_0} - \code{val_1}).
This is reminiscent of a likelihood ratio test statistic albeit the objective function is not a negative log-likelihood
but the negative of the maximum product spacing metric.
}
\details{
High values of this difference speak against the null-model (i.e. high \code{val_0} indicates bad fit under 0-model and low values of \code{val_1} indicate a good fit under the more general model1.
The test is implemented as a parametric bootstrap test, i.e. we
\enumerate{
\item take given null-model fit as ground truth
\item regenerate data according to this model.
\item recalculate the test statistic
\item appraise the observed test statistic in light of the generated distribution under H0
}
}
