% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{Detect}
\alias{Detect}
\title{Detect variable type in a data matrix}
\usage{
Detect(x, n = 5)
}
\arguments{
\item{x}{is the data matrix that need to be detected.}

\item{n}{is a number, indicating how many levels, if outnumbered, can be seen
as an numeric variable, rather than a categorical variable.}
}
\value{
the variable type for every column, can either be "numeric" or
"character".
}
\description{
This function detects the type of the variables in a data matrix. Types 
can be continuous only, categorical only or mixed type. The rule for
defining a variable as a categorical variable is when: (1) it is a character
vector, (2) it contains no more than n = 5 unique values
}
\examples{
data(parkinson)
Detect(parkinson)
data(spect)
Detect(spect)
data(tic)
table(Detect(tic))
}
