% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_impala.R
\name{src_impala}
\alias{src_impala}
\title{Connect to Impala and create a remote dplyr data source}
\usage{
src_impala(drv, ..., auto_disconnect = TRUE)
}
\arguments{
\item{drv}{an object that inherits from \code{\link[DBI]{DBIDriver-class}}.
For example, an object returned by \code{\link[odbc]{odbc}} or
\code{\link[RJDBC]{JDBC}}}

\item{...}{arguments passed to the underlying Impala database connection
method \code{\link[DBI]{dbConnect}}. See
\code{\link[odbc]{dbConnect,OdbcDriver-method}} or
\code{\link[RJDBC]{dbConnect,JDBCDriver-method}}}

\item{auto_disconnect}{Should the connection to Impala be automatically
closed when the object returned by this function is deleted? Pass \code{NA}
to auto-disconnect but print a message when this happens.}
}
\value{
An object with class \code{src_impala}, \code{src_sql}, \code{src}
}
\description{
\code{src_impala} creates a SQL backend to dplyr for
\href{https://impala.incubator.apache.org/}{Apache Impala (incubating)},
the massively parallel processing query engine for Apache Hadoop.

\code{src_impala} can work with any DBI-compatible interface that provides
connectivity to Impala. Currently, two packages that can provide this
connectivity are odbc and RJDBC.
}
\examples{
# Using ODBC connectivity:

\dontrun{
library(odbc)
drv <- odbc::odbc()
impala <- src_impala(
  drv = drv,
  driver = "Cloudera ODBC Driver for Impala",
  host = "host",
  port = 21050,
  database = "default",
  uid = "username",
  pwd = "password"
)}

# Using JDBC connectivity:

\dontrun{
library(RJDBC)
Sys.setenv(JAVA_HOME = "/path/to/java/home/")
impala_classpath <- list.files(
  path = "/path/to/jdbc/driver",
  pattern = "\\\\.jar$",
  full.names = TRUE
)
.jinit(classpath = impala_classpath)
drv <- JDBC(
  driverClass = "com.cloudera.impala.jdbc41.Driver",
  classPath = impala_classpath,
  identifier.quote = "`"
)
impala <- src_impala(
  drv,
  "jdbc:impala://host:21050",
  "username",
  "password"
)}
}
\seealso{
\href{https://www.cloudera.com/downloads/connectors/impala/odbc.html}{Impala
ODBC driver},
\href{https://www.cloudera.com/downloads/connectors/impala/jdbc.html}{Impala
JDBC driver}
}
