% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_wear.R
\name{mark_nonwear}
\alias{mark_nonwear}
\title{Mark accelerometer non-wear time}
\usage{
mark_nonwear(data, nonwear_stage1, nonwear_stage2, window2)
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{nonwear_stage1, nonwear_stage2}{A numeric vector containing the
binary non-wear classification (0 is wear and 1 is non-wear) of each
algorithm's stage per \code{window2} blocks as obtained with the
\code{detect_nonwear()} function.}

\item{window2}{Window 2 size, in minutes, for the non-wear
detection algorithm. Must be the same value as used by the
\code{detect_nonwear()} function.}
}
\value{
The \code{impactr_data} object provided by \code{data} with a new
column named \code{wear} with the binary wear classification (0 is non-wear and
1 is wear) per sample. Notice that this binary classification is regarding
the wear time NOT non-wear.
}
\description{
Creates a new column, named \code{wear}, in the \code{impactr_data} object
provided by \code{data} indicating its classification of wear or non-wear
time.
}
\details{
This is an internal function, designed to be used inside the wrapper
function \link[=remove_nonwear]{remove_nonwear()} that integrates all
steps of detection, removal and inspection of accelerometer non-wear time.
}
\seealso{
\code{\link[=detect_nonwear]{detect_nonwear()}},
\code{\link[=plot_nonwear]{plot_nonwear()}},
\code{\link[=summarise_nonwear]{summarise_nonwear()}},
\code{\link[=delete_nonwear]{delete_nonwear()}}
}
\keyword{internal}
