% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_match_number.R
\name{HLA_match_number}
\alias{HLA_match_number}
\title{HLA_match_number}
\usage{
HLA_match_number(
  GL_string_recip,
  GL_string_donor,
  loci,
  direction = "bidirectional"
)
}
\arguments{
\item{GL_string_recip}{A GL string representing the recipient's HLA genotype.}

\item{GL_string_donor}{A GL string representing the donor's HLA genotype.}

\item{loci}{A character vector specifying the loci to be considered for
mismatch calculation. HLA-DRB3/4/5 (and their serologic equivalents DR51/52/53)
are considered once locus for this function, and should be called in this argument
as "HLA-DRB3/4/5" or "HLA-DR51/52/53", respectively.}

\item{direction}{A character string indicating the direction of match.
Options are "HvG" (host vs. graft), "GvH" (graft vs. host), "bidirectional"
(the minimum value of "HvG" and "GvH").}
}
\value{
An integer value or a character string:
- If `loci` includes only one locus, the function returns an integer
mismatch count for that locus.
- If `loci` includes multiple loci, the function returns a character
string in the format "Locus1=Count1, Locus2=Count2, ...".
}
\description{
Calculates the number of HLA matches as two minus the number of
mismatches from `HLA_mismatch_number`. Homozygous mismatches are counted twice.
Supports match calculations for host-vs-graft (HvG), graft-vs-host (GvH),
or bidirectional. Bidirectional matching is the default, but can be overridden
using the "direction" argument.
}
\examples{

file <- HLA_typing_1[, -1]
GL_string <- HLA_columns_to_GLstring(file, HLA_typing_columns = everything())
GL_string_recip <- GL_string[1]
GL_string_donor <- GL_string[2]

loci <- c("HLA-A", "HLA-B")

# Calculate mismatch numbers (Host vs. Graft)
HLA_match_number(GL_string_recip, GL_string_donor, loci, direction = "HvG")

# Calculate mismatch numbers (Graft vs. Host)
HLA_match_number(GL_string_recip, GL_string_donor, loci, direction = "GvH")

# Calculate mismatch numbers (Bidirectional)
HLA_match_number(GL_string_recip, GL_string_donor,
  loci,
  direction = "bidirectional"
)

}
