% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixset.R
\name{grow}
\alias{grow}
\alias{shrink}
\title{Grow/shrink a pixel set}
\usage{
grow(px, x, y = x, z = x, boundary = TRUE)

shrink(px, x, y = x, z = x, boundary = TRUE)
}
\arguments{
\item{px}{a pixset}

\item{x}{either an integer value, or an image/pixel set.}

\item{y}{width of the rectangular structuring element (if x is an integer value)}

\item{z}{depth of the rectangular structuring element (if x is an integer value)}

\item{boundary}{are pixels beyond the boundary considered to have value TRUE or FALSE (default TRUE)}
}
\description{
Grow/shrink a pixel set through morphological dilation/erosion. The default is to use square or rectangular structuring elements, but an arbitrary structuring element can be given as input. 
A structuring element is a pattern to be moved over the image: for example a 3x3 square. In "shrink" mode, a element of the pixset is retained only if and only the structuring element fits entirely within the pixset. In "grow" mode, the structuring element acts like a neighbourhood: all pixels that are in the original pixset *or* in the neighbourhood defined by the structuring element belong the new pixset.
}
\section{Functions}{
\itemize{
\item \code{shrink}: shrink pixset using erosion
}}

\examples{
#A pixel set:
a <- grayscale(boats) > .8
plot(a)
#Grow by a 8x8 square
grow(a,8) \%>\% plot
#Grow by a 8x2 rectangle
grow(a,8,2) \%>\% plot
#Custom structuring element
el <- matrix(1,2,2) \%>\% as.cimg
all.equal(grow(a,el),grow(a,2))
#Circular structuring element
px.circle(5) \%>\% grow(a,.) \%>\% plot
#Sometimes boundary conditions matter
im <- imfill(10,10)
px <- px.all(im)
shrink(px,3,bound=TRUE) \%>\% plot(main="Boundary conditions: TRUE")
shrink(px,3,bound=FALSE) \%>\% plot(main="Boundary conditions: FALSE")
}
