% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/cimg_class.R
\name{RGBtoHSL}
\alias{HSItoRGB}
\alias{HSLtoRGB}
\alias{HSVtoRGB}
\alias{LabtoRGB}
\alias{LabtoXYZ}
\alias{LabtosRGB}
\alias{RGBtoHSI}
\alias{RGBtoHSL}
\alias{RGBtoHSV}
\alias{RGBtoLab}
\alias{RGBtoXYZ}
\alias{RGBtoYCbCr}
\alias{RGBtoYUV}
\alias{RGBtosRGB}
\alias{XYZtoLab}
\alias{XYZtoRGB}
\alias{YCbCrtoRGB}
\alias{YUVtoRGB}
\alias{imager.colourspaces}
\alias{sRGBtoLab}
\alias{sRGBtoRGB}
\title{Colour space conversions in imager}
\usage{
RGBtoHSL(im)

RGBtoXYZ(im)

XYZtoRGB(im)

HSLtoRGB(im)

RGBtoHSV(im)

HSVtoRGB(im)

RGBtoHSI(im)

HSItoRGB(im)

RGBtosRGB(im)

sRGBtoRGB(im)

RGBtoYCbCr(im)

YCbCrtoRGB(im)

RGBtoYUV(im)

YUVtoRGB(im)

LabtoRGB(im)

RGBtoLab(im)

LabtoXYZ(im)

XYZtoLab(im)

LabtosRGB(im)

sRGBtoLab(im)
}
\arguments{
\item{im}{an image}
}
\description{
All functions listed here assume the input image has three colour channels (spectrum(im) == 3)
}
\section{Functions}{
\itemize{
\item \code{RGBtoHSL}: RGB to HSL conversion

\item \code{RGBtoXYZ}: CIE RGB to CIE XYZ (1931) conversion, D65 white point

\item \code{XYZtoRGB}: CIE XYZ to CIE RGB (1931) conversion, D65 white point

\item \code{HSLtoRGB}: HSL to RGB conversion

\item \code{RGBtoHSV}: RGB to HSV conversion

\item \code{HSVtoRGB}: HSV to RGB conversion

\item \code{RGBtoHSI}: RGB to HSI conversion

\item \code{HSItoRGB}: HSI to RGB conversion

\item \code{RGBtosRGB}: RGB to sRGB conversion

\item \code{sRGBtoRGB}: sRGB to RGB conversion

\item \code{RGBtoYCbCr}: RGB to YCbCr conversion

\item \code{YCbCrtoRGB}: YCbCr to RGB conversion

\item \code{RGBtoYUV}: RGB to YUV conversion

\item \code{YUVtoRGB}: YUV to RGB conversion

\item \code{LabtoRGB}: Lab to RGB (linear)

\item \code{RGBtoLab}: RGB (linear) to Lab

\item \code{LabtoXYZ}: Lab to XYZ

\item \code{XYZtoLab}: XYZ to Lab

\item \code{LabtosRGB}: Lab to sRGB

\item \code{sRGBtoLab}: sRGB to Lab
}}

