% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycles.R
\name{find_cycle}
\alias{find_cycle}
\title{Finds a cycle in a graph, if there is one}
\usage{
find_cycle(graph, mode = c("out", "in", "all", "total"))
}
\arguments{
\item{graph}{The input graph.}

\item{mode}{Character constant specifying how to handle directed graphs.
\code{out} follows edge directions, \verb{in} follows edges in the reverse direction,
and \code{all} ignores edge directions. Ignored in undirected graphs.}
}
\value{
A list of integer vectors, each integer vector is a path from
the source vertex to one of the target vertices. A path is given by its
vertex ids.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function returns a cycle of the graph, in terms of both its vertices
and edges. If the graph is acyclic, it returns empty vertex and edge
sequences.

Use \code{\link[=is_acyclic]{is_acyclic()}} to determine if a graph has cycles, without returning
a specific cycle.
}
\examples{

g <- make_lattice(c(3, 3))
find_cycle(g)

# Empty results are returned for acyclic graphs
find_cycle(sample_tree(5))

}
\seealso{
Graph cycles
\code{\link{feedback_arc_set}()},
\code{\link{feedback_vertex_set}()},
\code{\link{girth}()},
\code{\link{has_eulerian_path}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{simple_cycles}()}
}
\concept{cycles}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Cycles.html#igraph_find_cycle}{\code{find_cycle()}}.}

