% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{difference.igraph}
\alias{difference.igraph}
\alias{graph.difference}
\alias{\%m\%}
\title{Difference of graphs}
\usage{
\method{difference}{igraph}(big, small, byname = "auto", ...)
}
\arguments{
\item{big}{The left hand side argument of the minus operator. A directed or
undirected graph.}

\item{small}{The right hand side argument of the minus operator. A directed
ot undirected graph.}

\item{byname}{A logical scalar, or the character scalar \code{auto}. Whether
to perform the operation based on symbolic vertex names. If it is
\code{auto}, that means \code{TRUE} if both graphs are named and
\code{FALSE} otherwise. A warning is generated if \code{auto} and one graph,
but not both graphs are named.}

\item{...}{Ignored, included for S3 compatibility.}
}
\value{
A new graph object.
}
\description{
The difference of two graphs are created.
}
\details{
\code{difference} creates the difference of two graphs. Only edges
present in the first graph but not in the second will be be included in the
new graph. The corresponding operator is \%m\%.

If the \code{byname} argument is \code{TRUE} (or \code{auto} and the graphs
are all named), then the operation is performed based on symbolic vertex
names. Otherwise numeric vertex ids are used.

\code{difference} keeps all attributes (graph, vertex and edge) of the
first graph.

Note that \code{big} and \code{small} must both be directed or both be
undirected, otherwise an error message is given.
}
\examples{

## Create a wheel graph
wheel <- union(make_ring(10),
                     make_star(11, center=11, mode="undirected"))
V(wheel)$name <- letters[seq_len(vcount(wheel))]

## Subtract a star graph from it
sstar <- make_star(6, center=6, mode="undirected")
V(sstar)$name <- letters[c(1,3,5,7,9,11)]
G <- wheel \%m\% sstar
print_all(G)
plot(G, layout=layout_nicely(wheel))
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
