% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gri.R
\name{gri}
\alias{gri}
\title{Calculate Glycemia Risk Index (GRI)}
\usage{
gri(data, tz = "")
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}

\item{tz}{\strong{Default: "".} A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
A tibble object with columns for subject id and GRI value. Rows
correspond to individual subjects.
}
\description{
The function gri produces a tibble object with values equal to
the glycemia risk index (GRI) metric. The output columns are subject id and
GRI value. ' The output rows correspond to subjects.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
column for GRI is returned. The formula for GRI is as follows:

\eqn{(3.0 × VLow) + (2.4 × Low) + (1.6 × VHigh) + (0.8 × High)}

where VLow, Low, VHigh, and High correspond to the percent of glucose values
in the ranges <54 mg/dL, 54-70 mg/dL, >250 mg/dL, and 180-250 mg/dL respectively.
The maximum allowed value for GRI is 100\%, any calculated values higher than
100 are capped.
}
\examples{

data(example_data_1_subject)
gri(example_data_1_subject)

data(example_data_5_subject)
gri(example_data_5_subject, tz = 'GMT')

}
\references{
Klonoff et al. (2022) A Glycemia Risk Index (GRI) of Hypoglycemia and Hyperglycemia
for Continuous Glucose Monitoring Validated by Clinician Ratings.
\emph{J Diabetes Sci Technol}
\doi{10.1177/19322968221085273}.
}
\author{
Elizabeth Chun
}
