% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_agp.R
\name{plot_agp}
\alias{plot_agp}
\title{Plot Ambulatory Glucose Profile (AGP) modal day}
\usage{
plot_agp(data, LLTR = 70, ULTR = 180, dt0 = NULL, inter_gap = 45, tz = "", title = FALSE)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl". Should only be data for 1 subject. In case multiple subject ids are detected, the warning is produced and only 1st subject is used.}

\item{LLTR}{Lower Limit of Target Range, default value is 70 mg/dL.}

\item{ULTR}{Upper Limit of Target Range, default value is 180 mg/dL.}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}

\item{title}{Indicator whether the title of the plot should display the subject ID. The default is FALSE (no title).}
}
\value{
Plot of a 24 hr modal day collapsing all data to a single day.
}
\description{
The function plot_agp produces an AGP plot that collapses all data into a single 24 hr "modal day".
}
\details{
Only a single subject's data may be plotted. The horizontal green lines represent the target range, default is 70-180 mg/dL. The black line is the median glucose value for each time of day. The dark blue shaded area
represents 50\% of glucose values - those between the 25th and 75 quartiles. The light
blue shaded area shows 90\% of the glucose values - those between the 5th and 95th quartiles.
Additionally, the percents shown on the right hand side of the plot show which quartile each line refers to -
e.g. the line ending at 95\% is the line corresponding to the 95th quartile of glucose values.
}
\examples{

data(example_data_1_subject)
plot_agp(example_data_1_subject)

}
\references{
Johnson et al. (2019) Utilizing the Ambulatory Glucose Profile to Standardize and
Implement Continuous Glucose Monitoring in Clinical Practice,
\emph{Diabetes Technology and Therapeutics} \strong{21:S2} S2-17-S2-25,
\doi{10.1089/dia.2019.0034}.
}
\author{
Elizabeth Chun
}
