% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{tand}
\alias{tand}
\title{Tangent (in degrees) [GNU Octave/MATLAB compatible]}
\usage{
tand(x)
}
\arguments{
\item{x}{A numeric vector containing values in degrees}
}
\value{
The tangent of each element of \code{x} in degrees. Zero for any
"elements where \code{x} / 180 is an integer and \code{Inf} for elements where
(\code{x} - 90) / 180 is an integer."
}
\description{
Calculates the value of tangent for each element of \code{x} in degrees in a
manner compatible with GNU Octave/MATLAB. Zero is returned for any "elements
where \code{x} / 180 is an integer and \code{Inf} for elements where
(\code{x} - 90) / 180 is an integer." Reference: Eaton.
}
\note{
Note: If you have a radian (rad) angle value, use \code{\link[base]{tan}} instead.
}
\examples{

library(iemisc)

# Examples from GNU Octave tand
tand(seq(10, 80, by = 10))

tand(c(0, 180, 360))

tand(c(90, 270))


}
\references{
John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 553.
}
\author{
David Bateman (GNU Octave tand), Irucka Embry
}
