% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{imImpAll}
\alias{imImpAll}
\title{Impute missing data}
\usage{
imImpAll(fit.rst, data.all = NULL, deltas = 0, normal = TRUE, n.imp = 5,
  endponly = TRUE, update.progress = NULL, imputeNone = FALSE, ...)
}
\arguments{
\item{fit.rst}{A class \code{IDEMFIT} results generated by
\code{\link{imFitModel}}.}

\item{data.all}{A dataframe containing subjects with missing data. The
default value is NULL, in which case the function will impute missing
data for subjects in the original dataset in the class \code{IDEMFIT}
object \code{fit.rst}}

\item{deltas}{Vector of imputation sensitivity parameters}

\item{normal}{Logical variable indicating whether normality assumption should
be made for the residuals}

\item{n.imp}{Number of complete datasets required}

\item{endponly}{Logical variable that indicates whether clinical outcomes not
used in calculating the functional outcome are considered as missing and
should be imputed. The default is \code{FALSE}, indicating that all
missing clinical outcomes will be imputed sequentially}

\item{update.progress}{Parameter reserved for run \code{idem} in GUI mode}

\item{imputeNone}{If \code{TRUE}, no imputation will be conducted. The data
from subjects that do not need imputation will be returned}

\item{...}{options to call STAN sampling. These options include
\code{chains}, \code{iter}, \code{warmup}, \code{thin}, \code{algorithm}.
See \code{rstan::sampling} for details.}
}
\value{
If \code{imputeNone} is TRUE, return a dataset with the original data for the
subset of subjects who died at the end of the study or had no missing outcomes.

Otherwise, return a class \code{IDEMIMP} list with components
\describe{
\item{lst.var}{List of parameters}
\item{complete}{A dataset with  the original data for
the subset of subjects who died at the end of the study or had no missing
outcomes and the \code{n.imp} imputed missing outcomes for subjects who need
missing value imputation.
}
\item{n.imp}{Number of imputed complete datasets}
\item{deltas}{Imputation sensitivity parameters}
\item{org.data}{Original dataset}
\item{normal}{Normal assumption for the imputation}
\item{stan.par}{STAN options}
}
}
\description{
Conduct imputation under benchmark assumptions or for sensitivity analysis
for a given set of subjects using the model fitting results
}
\examples{

\dontrun{
rst.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
rst.fit  <- imFitModel(rst.abc);
rst.imp <- imImpAll(rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 2, iter = 2000, warmup = 1000);}

}

