cloud <- ichimoku(sample_ohlc_data)
stratlist <- autostrat(cloud, n = 2, dir = "short", level = 2)
grid <- mlgrid(cloud, y = "logret", type = "numeric")
grid2 <- mlgrid(cloud, y = "ret", type = "boolean", dir = "short", unique = FALSE)

test_that("autostrat ok", {
  expect_type(stratlist, "list")
  expect_length(stratlist, 2L)
  expect_type(autostrat(cloud, n = 1), "list")
  expect_type(autostrat(cloud, n = 1, level = 3), "list")
  expect_warning(autostrat(cloud, n = 1, level = "a"), regexp = "Invalid level")
  expect_error(autostrat(sample_ohlc_data), regexp = "ichimoku object")
})

test_that("mlgrid ok", {
  expect_s3_class(grid, "data.frame")
  expect_true(dim(grid)[2L] == 38)
  expect_true(attr(grid, "mlgrid"))
  expect_identical(attr(grid, "y"), "logret")
  expect_identical(attr(grid, "direction"), "long")
  expect_s3_class(grid2, "data.frame")
  expect_true(dim(grid2)[2L] == 75)
  expect_true(attr(grid2, "mlgrid"))
  expect_identical(attr(grid2, "y"), "ret")
  expect_identical(attr(grid2, "direction"), "short")
  expect_error(mlgrid(sample_ohlc_data), regexp = "ichimoku object")
})

test_that("look ok", {
  list1 <- look(cloud)
  expect_type(list1, "list")
  expect_length(list1, 3L)
  list2 <- look(stratlist[[1L]])
  expect_type(list2, "list")
  expect_length(list2, 4L)
  list3 <- look(grid)
  expect_type(list3 , "list")
  expect_length(list3, 3L)
  list4 <- look(stratlist)
  expect_type(list4, "list")
  expect_length(list4, 2L)
  expect_s3_class(look(stratlist, which = 1), "ichimoku")
  expect_null(look(sample_ohlc_data))
  expect_silent(look(sample_ohlc_data))
  expect_error(look(stratlist, which = 9), regexp = "one of the strategies")
})
