% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda}
\alias{oanda}
\title{OANDA Price Data}
\usage{
oanda(
  instrument,
  granularity = c("D", "W", "M", "H12", "H8", "H6", "H4", "H3", "H2", "H1", "M30",
    "M15", "M10", "M5", "M4", "M2", "M1", "S30", "S15", "S10", "S5"),
  count = NULL,
  from = NULL,
  to = NULL,
  price = c("M", "B", "A"),
  server = c("practice", "live"),
  apikey
)
}
\arguments{
\item{instrument}{string containing the base currency and quote currency
delimited by a '_' (for example "USD_JPY"). Use the
\code{\link{oanda_instruments}} function to return a list of all valid
instruments.}

\item{granularity}{[default "D"] the granularity of the price data to fetch,
one of "M", "W", "D", "H12", "H8", "H6", "H4", "H3", "H2", "H1", "M30",
"M15", "M10", "M5", "M4", "M2", "M1", "S30", "S15", "S10", "S5".}

\item{count}{(optional) the number of periods to return. The API supports a
maximum of 5000 for each individual request, and defaults to 500 if not
specified. If both 'from' and 'to' are specified, 'count' is ignored, as
the time range combined with 'granularity' will determine the number of
periods to return.}

\item{from}{(optional) the start of the time range for which to fetch price
data, for example "2020-02-01".}

\item{to}{(optional) the end of the time range for which to fetch price data,
for example "2020-06-30".}

\item{price}{[default "M"] pricing component, one of "M" (midpoint), "B" (bid)
or "A" (ask).}

\item{server}{[default "practice"] select either the "practice" or "live" server
depending on the account type held with OANDA.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
A data.frame containing the price data requested.
}
\description{
Retrieve price data for major currencies, metals, commodities, government
    bonds and stock indices from the OANDA fxTrade API.
}
\details{
This function queries the OANDA fxTrade API.

    Requires an fxTrade account with OANDA \url{https://www.oanda.com/forex-trading/}.
    If you do not already hold a live account, you may register for an OANDA
    fxTrade practice / demo account. There is a link on your OANDA fxTrade
    account profile page 'Manage API Access' (My Account -> My Services ->
    Manage API Access). From there, a personal access token to use with the
    OANDA API can be generated, as well as revoked.

    The \code{\link{oanda_set_key}} function can be used to save the API key
    in the system credential store so that it is automatically recognised in
    future (requires the 'keyring' package to be installed).

    For further details please refer to the OANDA fxTrade API vignette by
    running: \code{vignette("xoanda", package = "ichimoku")}.

    'OANDA' and 'fxTrade' are trademarks owned by OANDA Corporation, an
    entity unaffiliated with the ichimoku package.
}
\examples{
\dontrun{
# OANDA fxTrade API key required to run this example
prices <- oanda("USD_JPY")
ichimoku(prices)

oanda("EUR_JPY", granularity = "H1", count = 250, from = "2020-02-01", price = "B")
}

}
