% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive.R
\name{archive}
\alias{archive}
\title{Read/write ichimoku objects <> Arrow Archive}
\usage{
archive(..., object, filename)
}
\arguments{
\item{...}{unnamed arguments will be parsed as 'filename' if there is only
one argument, 'object' and 'filename' if there are two arguments.}

\item{object}{(for write operations) an ichimoku object.}

\item{filename}{string file path, URI, or OutputStream, or path in a file
system (SubTreeFileSystem).}
}
\value{
For read operations: the ichimoku object originally archived.

    For write operations: invisible NULL. 'object' is written to 'filename'
    as a side effect.
}
\description{
Read and write ichimoku objects to/from archival storage in the Apache Arrow
    IPC file format.
}
\details{
For read operations: specify only 'filename'. 'filename' is read and
    the return value may be assigned to an object. A confirmation message is
    issued if the file read operation has been successful.

    For write operations: specify both 'object' and 'filename'. 'object' will
    be written to 'filename'. A confirmation message is issued if the file
    write operation has been successful.

    Note: this function requires the 'arrow' package to be installed.
}
\section{Data Validation}{


    If the 'openssl' package is available, a sha256 hash of the original
    object is written to the archive. This allows the data integrity of the
    restored object to be verified when the archive is read back.

    For write operations: confirmation of the sha256 hash is displayed if
    this has been successfully written to file.

    For read operations: a 'data verified' message is issued if a correct
    sha256 hash is found in the data file.
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
filename <- tempfile()

archive(cloud, filename)

restored <- archive(filename)

unlink(filename)

}
