% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFishStockReferencePoints.R
\name{getFishStockReferencePoints}
\alias{getFishStockReferencePoints}
\title{Get Reference Points}
\usage{
getFishStockReferencePoints(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{to allow scope for back compatibility}
}
\value{
A data frame.
}
\description{
Get biological reference points for all stocks in a given assessment year.
}
\examples{
\dontrun{
assessmentKey <- findAssessmentKey("cod-2224", year = 2016)
refpts <- getFishStockReferencePoints(assessmentKey)
refpts

#To get all reference points in a given assessment year:
keys2016 <- findAssessmentKey(year = 2016)
refpts2016 <- getFishStockReferencePoints(keys2016)
refpts2016
}
}
\seealso{
\code{\link{getSAG}} supports querying many years and quarters in one
  function call.

\code{\link{getListStocks}} and \code{\link{getSummaryTable}} get a list of
  stocks and summary results.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar and Scott Large.
}
