% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convert.R
\name{icd9LongToWide}
\alias{icd9LongToWide}
\title{convert ICD data from long to wide format}
\usage{
icd9LongToWide(icd9df, visitId = NULL, icd9Field = NULL, prefix = "icd_",
  min.width = 0, aggregate = TRUE, return.df = FALSE)
}
\arguments{
\item{icd9df}{data.frame of long-form data, one column for visitId and one
for ICD code}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visitId}
was not specified, then the first column of the data frame is used.}

\item{icd9Field}{The column in the data frame which contains the ICD codes.
This is a character vector of length one. If it is \code{NULL}, \code{icd9}
will attempt to guess the column name, looking for progressively less
likely possibilities until it matche a single column. Failing this, it will
take the first column in the data frame. Specifying the column using this
argument avoids the guesswork.}

\item{prefix}{character, default "icd_" to prefix new columns}

\item{min.width,}{single integer, if specified, writes out this many columns
even if no patients have that many codes. Must be greater than or equal to
the maximum number of codes per patient.}

\item{aggregate}{single logical value, if TRUE (the default) will take more
time to find out-of-order visitIds, and combine all the codes for each
unique visitId. If \code{FALSE}, then out-of-order visitIds will result in
a row in the output data per contiguous block of identical visitIds.}

\item{return.df}{single logical value, if \code{TRUE}, return a data frame
with a field for the visitId. This may be more convenient, but the default
of \code{FALSE} gives the more natural return data of a matrix with
rownames being the visitIds.}
}
\description{
This is more complicated than reshape or reshape2::dcast allows.
  This is a reasonably simple solution using built-in functions.
}
\examples{
longdf <- data.frame(visitId = c("a", "b", "b", "c"),
    icd9 = c("441", "4424", "443", "441"))
  icd9LongToWide(longdf)
  icd9LongToWide(longdf, prefix = "ICD10_")
}
\seealso{
Other ICD-9 convert: \code{\link{convert}},
  \code{\link{icd9DecimalToParts}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToShort}},
  \code{\link{icd9ShortToParts}};
  \code{\link{icd9ChaptersToMap}};
  \code{\link{icd9DropLeadingZeroes}},
  \code{\link{icd9DropLeadingZeroesDecimal}},
  \code{\link{icd9DropLeadingZeroesMajor}},
  \code{\link{icd9DropLeadingZeroesShort}};
  \code{\link{icd9WideToLong}}
}
\keyword{manip}

