% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/explain.R
\name{icd9Condense}
\alias{icd9Condense}
\alias{icd9CondenseDecimal}
\alias{icd9CondenseShort}
\alias{icd9CondenseToMajor}
\alias{icd9CondenseToMajorDecimal}
\alias{icd9CondenseToMajorShort}
\title{Condense ICD-9 code by replacing complete families with parent codes}
\usage{
icd9Condense(icd9, isShort, onlyReal = NULL, toMajor = TRUE)

icd9CondenseToMajor(icd9, isShort = icd9GuessIsShort(icd9), onlyReal = NULL)

icd9CondenseToMajorDecimal(icd9Decimal, onlyReal = NULL)

icd9CondenseToMajorShort(icd9Short, onlyReal = NULL, warnReal = FALSE)

icd9CondenseShort(icd9Short, onlyReal = NULL, toMajor = TRUE)

icd9CondenseDecimal(icd9Decimal, onlyReal = NULL, toMajor = TRUE)
}
\arguments{
\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{onlyReal}{single logical value, if TRUE, will limit the search to those
codes which appear in the master list, not just syntactically valid codes.
Since nearly valid, out-dated or new codes may be missed, not limiting to
'real' values will be useful. Ultimately, there will need to be annual (and
all-time) master lists of codes and the ability to test against a given
master list given the year of the ICD-9 coding.}

\item{toMajor}{Most major codes are not \emph{real}, e.g. Salmonella 003 is a
major category, but is not itself used as a diagnostic code. Therefore,
strictly, asking for only \emph{real} codes excludes the major. We'll turn
a blind eye to this if we specifically request majors with toMajor.}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{warnReal}{single logical value, if \code{TRUE}, give warnings when
there is discrepancy between \code{onlyReal} being \code{TRUE} yet data
containing undefined codes.}
}
\description{
This can be thought of as the inverse operation to
  \code{icd9Children}.
}
\details{
\code{icd9CondenseToMajor} family of functions are required, at
  least in this release because of issue #37 in github. This function just
  gets majors, unlike \code{icd9CondenseShort}.
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{\%i9da\%}}, \code{\link{\%i9mj\%}},
  \code{\link{\%i9s\%}}, \code{\link{\%i9sa\%}},
  \code{\link{icd9ExpandRange}},
  \code{\link{icd9ExpandRangeDecimal}},
  \code{\link{icd9ExpandRangeMajor}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9Children}}, \code{\link{icd9Children}},
  \code{\link{icd9ChildrenDecimal}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9ExpandMinor}}
}

