% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R, R/comorbid.R
\name{icd9ComorbidShort}
\alias{icd9Comorbid}
\alias{icd9ComorbidAhrq}
\alias{icd9ComorbidElix}
\alias{icd9ComorbidQuanDeyo}
\alias{icd9ComorbidQuanElix}
\alias{icd9ComorbidShort}
\alias{icd9Comorbidities}
\alias{icd9ComorbiditiesAhrq}
\alias{icd9ComorbiditiesElixHauser}
\alias{icd9ComorbiditiesQuanDeyo}
\alias{icd9ComorbiditiesQuanElixhauser}
\title{find comorbidities from ICD-9 codes.}
\usage{
icd9ComorbidShort(icd9df, icd9Mapping, visitId = "visitId",
  icd9Field = "icd9")

icd9Comorbid(icd9df, icd9Mapping, visitId = "visitId", icd9Field = "icd9",
  isShort = icd9GuessIsShort(icd9df[[icd9Field]]),
  isShortMapping = icd9GuessIsShort(icd9Mapping))

icd9ComorbidAhrq(icd9df, isShort = icd9GuessIsShort(icd9df[[icd9Field]]),
  visitId = "visitId", icd9Field = "icd9", abbrevNames = TRUE,
  applyHierarchy = TRUE)

icd9ComorbidQuanDeyo(icd9df, visitId = "visitId", icd9Field = "icd9",
  isShort = icd9GuessIsShort(icd9df[[icd9Field]]), abbrevNames = TRUE,
  applyHierarchy = TRUE)

icd9ComorbidQuanElix(icd9df, visitId = "visitId", icd9Field = "icd9",
  isShort = icd9GuessIsShort(icd9df[[icd9Field]]), abbrevNames = TRUE,
  applyHierarchy = TRUE)

icd9ComorbidElix(icd9df, visitId = "visitId", icd9Field = "icd9",
  isShort = icd9GuessIsShort(icd9df[[icd9Field]]), abbrevNames = TRUE,
  applyHierarchy = TRUE)

icd9Comorbidities(...)

icd9ComorbiditiesAhrq(...)

icd9ComorbiditiesElixHauser(...)

icd9ComorbiditiesQuanDeyo(...)

icd9ComorbiditiesQuanElixhauser(...)
}
\arguments{
\item{icd9df}{data frame containing columns for visitId (which is the feault
name), icd9 (default for the icd9 code), and  maybe also a POA flag.}

\item{icd9Mapping}{list (or name of a list if character vector of length one
is given as argument) of the comorbidities with each top-level list item
containing a vector of decimal ICD9 codes. This is in the form of a list,
with the names of the items corresponding to the comorbidities (e.g. "HTN",
or "diabetes") and the contents of each list item being a character vector
of short-form (no decimal place but ideally zero left-padded) ICD-9 codes.
No default: user should prefer to use the derivative functions, e.g.
icd9ComorbidAhrq, since these also provide appropriate naming for the
fields, and squashing the hierarchy (see \code{applyHierarchy} below)}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. Defaults to "visitId"}

\item{icd9Field}{The column in the data frame which contains the ICD-9 codes.
This is a character vector of length one.}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{isShortMapping}{Same as isShort, but applied to \code{icd9Mapping}
instead of \code{icd9df}. All the codes in a mapping should be of the same
type, i.e. short or decimal.}

\item{abbrevNames}{single locical value that defaults to \code{TRUE}, in
which case the ishorter human-readable names stored in e.g.
\code{ahrqComorbidNamesAbbrev} are applied to the data frame column names.}

\item{applyHierarchy}{single logical value that defaults to \code{TRUE}, in
which case the hierarchy defined for the mapping is applied. E.g. in
Elixhauser, you can't have uncomplicated and complicated diabetes both
flagged.}

\item{...}{arguments passed to the corresponding function from the alias.
E.g. all the arguments passed to \code{icd9ComorbiditiesAhrq} are passed on
to \code{icd9ComorbidAhrq}}
}
\description{
This is the main function which extracts co-morbidities from a
  set of ICD-9 codes. This is when some trivial post-processing of the
  comorbidity data is done, e.g. renaming to human-friendly field names, and
  updating fields according to rules. The exact fields from the original
  mappings can be obtained using \code{applyHierarchy = FALSE}, but for
  comorbidity counting, Charlson Score, etc., the rules should be applied.

For Charlson/Deyo comorbidities, strictly speaking, there is no
  dropping of more e.g. uncomplicated DM if complicated DM exists, however,
  this is probaably useful, in general and is essential when calculating the
  Charlson score.
}
\details{
There is a change in behavior from previous versions. The visitId
  column is (implicitly) sorted by using std::set container. Previously, the
  visitId output order was whatever R's \code{aggregate} produced.
}
\examples{
pts = data.frame(visitId = c("2", "1", "2", "3", "3"),
                   icd9 = c("39891", "40110", "09322", "41514", "39891"))
   icd9ComorbidShort(pts, ahrqComorbid) # visitId is now sorted
}

