% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ShortToParts}
\alias{icd9ShortToParts}
\title{extract major and minor parts of a decimal ICD-9 code}
\usage{
icd9ShortToParts(icd9Short, minorEmpty = "", invalidAction = c("ignore",
  "silent", "warn", "stop"))
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{minorEmpty}{vector of length one, to be used in place of
minor part of zero. Defaults to ""}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
data.frame with two columns. At least the minor part must be
  character, because "03" is different to "3", but "30" is the same as "3" at
  least in ICD-9 if leadingZeroes is true, then the major part must also be
  character.
}
\description{
accepts Vxxxx Exxxx or xxxxx
}
\keyword{manip}

