% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R, R/z-deprecated.R
\name{explain_code}
\alias{explain_code}
\alias{explain_icd}
\alias{explain_code.default}
\alias{explain_code.list}
\alias{explain_code.icd9}
\alias{explain_code.icd9cm}
\alias{explain_code.icd10cm}
\alias{explain_code.icd10}
\alias{icd_explain}
\alias{icd_explain.default}
\alias{icd_explain.icd10}
\alias{icd_explain.icd10cm}
\alias{icd_explain.icd9}
\alias{icd_explain.icd9cm}
\alias{icd_explain.list}
\alias{icd_explain}
\title{Explain ICD-9 and ICD-10 codes in English}
\usage{
explain_code(...)

explain_icd(...)

\method{explain_code}{default}(x, short_code = guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)

\method{explain_code}{list}(x, ...)

\method{explain_code}{icd9}(...)

\method{explain_code}{icd9cm}(x, short_code = guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)

\method{explain_code}{icd10cm}(x, short_code = guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)

\method{explain_code}{icd10}(x, short_code = guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)

icd_explain(...)

icd_explain.default(...)

icd_explain.icd10(...)

icd_explain.icd10cm(...)

icd_explain.icd9(...)

icd_explain.icd9cm(...)

icd_explain.list(...)

icd_explain(...)
}
\arguments{
\item{...}{arguments passed on to other functions}

\item{x}{vector or other structure of ICD codes to explain in human language}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{condense}{single logical value which indicates whether to condense the
given set of ICD-9 codes by replacing subsets of codes with 'parent' codes
which exactly encompass certain subsets. E.g. If all cholera diagnoses are
provided, only '001 - Cholera' needs to be displayed, not all sub-types.}

\item{brief}{single logical value, default is \code{FALSE}. If \code{TRUE},
the short description from the canonical CMS descriptions will be used,
otherwise the long description is used.}

\item{warn}{single logical value, default is \code{TRUE}, meaning that codes
which do not correspond to diagnoses, or to three-digit codes, will trigger
a warning.}
}
\value{
data frame, or list of data frames, with fields for ICD-9 code, name
  and description. There is no guarantee on the order of the returned
  descriptions. \code{explain_table} is designed to provide results in a
  reliable order (when not condensing codes, at least).
}
\description{
Convert 'decimal' format (123.45 style) ICD-9 codes into the name and
description for human review there are official ICD9-CM data tables, not with
conversion to decimal notation, but to the textual format.
}
\details{
\code{explain_icd} is a synonym for \code{\link{explain_code}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Explain ICD codes from a character vector, guessing
ICD version

\item \code{list}: Explain all ICD-9 codes in a list of vectors

\item \code{icd9}: explain character vector of ICD-9 codes.

\item \code{icd9cm}: explain character vector of ICD-9-CM codes

\item \code{icd10cm}: ICD-10-CM explanation, current a minimal implementation

\item \code{icd10}: ICD-10 explanation, falls back on ICD-10-CM until
ICD-10 WHO copyright workaround is available
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the prefix \code{icd::} instead, e.g., \code{icd::charlson}.
  Functions which specifically operate on either ICD-9 or ICD-10 codes or
  their sub-types will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\examples{
# by default, just show parent code and ignore children (428.0 not shown
# because 428 is present):
explain_code(icd9_map_ahrq$CHF[1:3])
# same without condensing the list. In this case, 428.0 is shown:
explain_code(icd9_map_ahrq$CHF[1:3], brief = TRUE)
# The first three in the ICD-10 equivalent are a little different:
explain_code(icd10_map_ahrq$CHF[1:3], brief = TRUE)
# nice to have magrittr, but not essential
library(magrittr, warn.conflicts = FALSE, quietly = TRUE)
explain_code(icd9_map_ahrq$CHF[1:3] \%>\% condense)
}
\keyword{internal}
