% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R, R/z-deprecated.R
\name{comorbid_df_to_mat}
\alias{comorbid_df_to_mat}
\alias{icd_comorbid_df_to_mat}
\alias{icd_comorbid_mat_to_df}
\title{convert comorbidity matrix to data frame}
\usage{
comorbid_df_to_mat(x, visit_name = get_visit_name(x),
  stringsAsFactors = getOption("stringsAsFactors"))

icd_comorbid_df_to_mat(...)

icd_comorbid_mat_to_df(...)
}
\arguments{
\item{x}{data frame, with a \code{visit_name} column (not necessarily first),
and other columns with flags for comorbidities, as such column names are
required.}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{stringsAsFactors}{Single logical value, describing whether the resulting data frame should have strings, e.g.
\code{visit_id} converted to factor. Default is to follow the current session option. This is identical to the
argument used in, among other base functions \code{as.data.frame}.}

\item{...}{arguments passed on to other functions}
}
\description{
convert matrix of comorbidities into data frame, preserving visit_name
information
}
\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\examples{
longdf <- icd_long_data(
            visit = c("a", "b", "b", "c"),
            icd9 = c("441", "4424", "443", "441")
            )
cmbdf <- icd9_comorbid_elix(longdf, return_df = TRUE)
class(cmbdf)
rownames(cmbdf)
mat.out <- comorbid_df_to_mat(cmbdf)
stopifnot(is.matrix(mat.out))
mat.out[, 1:4]
}
