% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{plot_BA}
\alias{plot_BA}
\title{Bland-Altman plot}
\usage{
plot_BA(data, y, id, rm = NULL, type = c("BA", "bars"))
}
\arguments{
\item{data}{A data frame containing at least two columns: outcome and subject identifier.}

\item{y}{Character string indicating the name of the outcome column in the data set.}

\item{id}{Character string indicating the name of the subjects column in the data set.}

\item{rm}{Optional. Character string indicating the name of  column that stands for the repeated measurements from the same subjects in the dataset.
Only needed to identify the differences in the Bland-Altman plot.}

\item{type}{Character. Which plot has to be drawn? Default option is Bland-Altman plot ("BA" option). Alternatively, the bar plot of the proportion of the differences can be created ("bars" option).}
}
\value{
A list with the following components:
\itemize{
\item \emph{plot}. An object of class ggplot. The plot generated.
\item \emph{data}. An object of class dataframe that contains the data used to generated the plot.
}
}
\description{
Draws the Bland-Altman plot. The differences among pair of data from the same subject
is represented on y-axis. The mean of data from the same subject is represented
on x-axis. Additionally, a bar plot with the proportions of differences
can be drawn.
}
\examples{
plot_BA(EPP,y="Social",id="id")
plot_BA(EPP,y="Social",id="id",rm="Year")
plot_BA(EPP,y="Social",id="id",type="bars")

}
