% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeroIBD.R
\name{zeroIBD}
\alias{zeroIBD}
\title{Probability of zero IBD}
\usage{
zeroIBD(sims, ids = NULL, threshold = 0)
}
\arguments{
\item{sims}{A list of genome simulations, as output by \code{\link[=ibdsim]{ibdsim()}}.}

\item{ids}{A vector with two ID labels. If NULL (default), these are deduced
from the \code{sims} object.}

\item{threshold}{A nonnegative number (default:0). Only IBD segments longer
than this are included in the computation.}
}
\value{
A list with the following two entries:
\itemize{
\item \code{zeroprob}: The fraction of \code{sims} in which \code{ids} have no IBD sharing
\item \code{stErr}: The standard error of \code{zeroprob}
}
}
\description{
Estimate the probability of no IBD sharing in a pairwise relationship.
}
\examples{
###
# The following example computes the probability of
# no IBD sharing between a pair of fourth cousins.
# We also show how the probability is affected by
# truncation, i.e., ignoring short segments.
###

# Define the pedigree
x = cousinPed(4)
cous = leaves(x)

# Simulate (increase N!)
s = ibdsim(x, N = 10)

# Probability of zero ibd segments. (By default all segs are used)
zeroIBD(s, ids = cous)

# Re-compute with positive threshold
zeroIBD(s, ids = cous, threshold = 1)

}
