% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileSimIBD.R
\name{profileSimIBD}
\alias{profileSimIBD}
\title{Simulate markers on a given IBD pattern}
\usage{
profileSimIBD(x, ibdpattern, markers = NULL)
}
\arguments{
\item{x}{A \code{ped} object}

\item{ibdpattern}{A simulation output of \code{ibdsim}}

\item{markers}{A vector with names of indices of markers attached to \code{x}}
}
\value{
An object similar to \code{x}
}
\description{
This function is similar to \code{profileSim()} but may be used to simulate
genotypes for linked markers.
}
\examples{
x = nuclearPed(2)

# Simulation of IBD in the pedigree
s = ibdsim(x, 1, ids = 3:4, map = uniformMap(M = 1), seed = 1729)[[1]]

# Attach 3 markers on chromosome 1
loci = list(
 list(afreq = c(a = 0.5, b = 0.5), chrom = 1, posCm = 20),
 list(afreq = c(a = 0.9, b = 0.1), chrom = 1, posCm = 30),
 list(afreq = c(a = 0.2, b = 0.3, c = .5), chrom = 1, posCm = 60)
)
x = setMarkers(x, loc = loci)

# Simulate genotypes on the given IBD pattern
profileSimIBD(x, s)


}
