% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{amts}
\alias{amts}
\title{Abbreviated Mental Test Score (AMTS)}
\format{
A data frame with 197 rows and 13 variables.
\describe{
  \item{id}{id number of the patient.}
  \item{agegrp}{a factor with levels 16-65, 66-75, 76-85, 86+ for the age  of the patient.}
  \item{sex}{a factor with levels male, female of the patient.}
  \item{age}{age of patient, with 1 if the respondent knows his/her own age and 0 otherwise.}
  \item{time}{time (nearest hour), with 1 if correct and 0 otherwise.}
  \item{address}{address, with 1 if correct and 0 otherwise.}
  \item{name}{name of hospital (or area of town if at home) , with 1 if correct and 0 otherwise.}
  \item{year}{current year, with 1 if correct and 0 otherwise.}
  \item{dob}{date of birth of patient, with 1 if correct and 0 otherwise.}
   \item{month}{month, with 1 if correct and 0 otherwise.}
   \item{firstww}{date of first world war, with 1 if correct and 0 otherwise.}
    \item{monarch}{name of monarch, with 1 if correct and 0 otherwise.}
    \item{countbac}{count backwards 20-1, with 1 if correct and 0 otherwise.}
}
}
\description{
A dataset containing the responses of 197 persons to the ten questions of the Abbreviated Mental Test Score (AMTS).
The AMTS is used to identify patients with dementia.
One point is given for each correct answer,
a score of 6 or less suggests that the patient has some mental impairment.
}
\examples{
data(amts)
str(amts)
}
\references{
Slade, A., Fear, J. & Tennant, A.  (2006) Identifying patients at risk of nursing home admission: The Leeds
Elderly Assessment Dependency Screening tool (LEADS). \emph{BMC Health Services Research}, 6:31.
}
\keyword{datasets}
