/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.InverseGaussianDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class InverseGaussianGen
extends RandomVariateGen {
    protected double mu = -1.0;
    protected double lambda = -1.0;

    public InverseGaussianGen(RandomStream s, double mu, double lambda) {
        super(s, new InverseGaussianDist(mu, lambda));
        this.setParams(mu, lambda);
    }

    public InverseGaussianGen(RandomStream s, InverseGaussianDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, double mu, double lambda) {
        return InverseGaussianDist.inverseF(mu, lambda, s.nextDouble());
    }

    public double getMu() {
        return this.mu;
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double mu, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        this.mu = mu;
        this.lambda = lambda;
    }
}

