/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;

abstract class WELL607base
extends RandomStreamBase {
    private static final long serialVersionUID = 120307L;
    static final double NORM = 2.3283064359965952E-10;
    static final int R = 19;
    static final int BUFFER_SIZE = 32;
    static final int NUM_BITS = 608;
    static final int MASK_STATE = 31;
    static final int W = 32;
    static final int P = 1;
    static final int MASKU = 1;
    static final int MASKL = -2;
    static final int M1 = 16;
    static final int M2 = 15;
    static final int M3 = 14;
    static final int R1 = 18;
    static final int R2 = 17;
    int state_i;
    int[] state;
    int[] stream;
    int[] substream;
    static final int w = 250;
    static final int v = 150;

    WELL607base() {
    }

    protected void advanceSeed(int[] seed, int[] p) {
        int i;
        int[] x = new int[19];
        for (i = 0; i < 19; ++i) {
            this.state[i] = seed[i];
        }
        this.state_i = 0;
        for (int j = 0; j < 19; ++j) {
            int b = p[j];
            for (int k = 0; k < 32; ++k) {
                if ((b & 1) == 1) {
                    for (int i2 = 0; i2 < 19; ++i2) {
                        int n = i2;
                        x[n] = x[n] ^ this.state[this.state_i + i2 & 0x1F];
                    }
                }
                b >>= 1;
                this.nextInt();
            }
        }
        for (i = 0; i < 19; ++i) {
            seed[i] = x[i];
        }
    }

    static void verifySeed(int[] seed) {
        if (seed.length < 19) {
            throw new IllegalArgumentException("Seed must contain 19 values");
        }
        boolean goodSeed = false;
        for (int i = 0; !goodSeed && i < 19; ++i) {
            if (seed[i] == 0) continue;
            goodSeed = true;
        }
        if (!goodSeed && seed[18] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("At least one of the element of the seed must not be 0. If this element is the last one, it mustn't be equal to 0x80000000 (-2147483648).");
        }
    }

    int[] getState() {
        int[] result = new int[19];
        for (int i = 0; i < 19; ++i) {
            result[i] = this.state[this.state_i + i & 0x1F];
        }
        return result;
    }

    String stringState() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 18; ++i) {
            sb.append(this.state[this.state_i + i & 0x1F] + ", ");
        }
        sb.append(this.state[this.state_i + 19 - 1 & 0x1F] + "}");
        return sb.toString();
    }

    int nextInt() {
        int z0 = this.state[this.state_i + 18 & 0x1F] & 0xFFFFFFFE | this.state[this.state_i + 17 & 0x1F] & 1;
        int z1 = this.state[this.state_i] ^ this.state[this.state_i] >>> 19 ^ (this.state[this.state_i + 16 & 0x1F] ^ this.state[this.state_i + 16 & 0x1F] >>> 11);
        int z2 = this.state[this.state_i + 15 & 0x1F] ^ this.state[this.state_i + 15 & 0x1F] << 14 ^ this.state[this.state_i + 14 & 0x1F];
        this.state[this.state_i] = z1 ^ z2;
        this.state[this.state_i - 1 & 0x1F] = z0 ^ z0 >>> 18 ^ z1 ^ (this.state[this.state_i] ^ this.state[this.state_i] << 5);
        --this.state_i;
        this.state_i &= 0x1F;
        return this.state[this.state_i];
    }

    public WELL607base clone() {
        WELL607base retour = null;
        retour = (WELL607base)super.clone();
        return retour;
    }
}

