% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap incidence time series}
\usage{
bootstrap(x, randomise_groups = FALSE)
}
\arguments{
\item{x}{An \verb{[incidence2]} object.}

\item{randomise_groups}{\verb{[bool]}

Should groups be randomised as well in the resampling procedure; respective
group sizes will be preserved, but this can be used to remove any
group-specific temporal dynamics.

If \code{FALSE} (default), data are resampled within groups.}
}
\value{
An \verb{[incidence2]} object.
}
\description{
This function can be used to bootstrap \verb{[incidence2]} objects. Bootstrapping
is done by sampling with replacement the original input dates.
}
\details{
As original data are not stored in \link[incidence2:incidence]{incidence2::incidence} objects, the
bootstrapping is achieved by multinomial sampling of date bins weighted by
their relative incidence.
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE)) {
    data(fluH7N9_china_2013, package = "outbreaks")
    i <- incidence(
        fluH7N9_china_2013,
        date_index = "date_of_onset",
        groups = "gender"
   )
   bootstrap(i)
}

}
\author{
Thibaut Jombart, Tim Taylor
}
