% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_errorI.R
\name{geom_errorI}
\alias{geom_errorI}
\title{Empirical Error Type I Associated with a Geometric Distribution}
\usage{
geom_errorI(c = 1, n = 150, theta0 = 0.5, R = 15000)
}
\arguments{
\item{c}{numeric, represents a positive value that defines a critical region. Default value is 1.}

\item{n}{numeric, represents the size of the sample. Default value is 100.}

\item{theta0}{numeric, represents the probability parameter under the null hypothesis of a sample from a Geometric distribution. Default value is 0.5.}

\item{R}{numeric, represents the number of replicates. Default value is 15000.}
}
\value{
A list with number of replicates, sample size, and critical value that were used in the calculation of error type I
associated with a likelihood ratio statistic.
}
\description{
\code{geom_errorI} is used to obtain an empirical error type I when we use a random sample from a Geometric distribution.
}
\examples{
# Error type I when we use a random sample of size 60 from a Geometric distribution,
# a critical value c = 0.01 and R = 20000 to test H_0: theta = 0.5 vs H_1: theta != 0.5
geom_errorI(0.01,n=60,theta0=0.5,R=20000)
}
\references{
Casella, G. and Berger, R. (2003). Statistical Inference, Second Edition. Duxbury Press.

Hogg, R., McKean, J., and Craig, A. (2019) Introduction to Mathematical Statistic.  Eighth edition. Pearson.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
