% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypr.R
\docType{methods}
\name{+,hypr,hypr-method}
\alias{+,hypr,hypr-method}
\title{Concatenate hypr objects}
\usage{
\S4method{+}{hypr,hypr}(e1, e2)
}
\arguments{
\item{e1, e2}{\code{hypr} objects to concatenate}
}
\value{
The combined \code{hypr} object
}
\description{
You can concatenate one or more \code{hypr} objects, i.e. combine their hypothesis to a single \code{hypr} object, by adding them with the \code{+} operator.
}
\details{
The resulting \code{hypr} object will contain all hypotheses of the constituting \code{hypr} objects but the resulting hypothesis and contrast matrices may differ. The result should be identical to creating a new \code{hypr} object with a list of hypotheses comprising all of the constituting hypr object’s hypotheses.
}
\examples{

(h1 <- hypr(a~i, b~i)) # a hypr object of two treatments

(h2 <- hypr(i~0)) # an intercept-only hypr object

hc <- h1 + h2

hc

}
