% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnsemble.R
\name{getFrcEnsem}
\alias{getFrcEnsem}
\title{Extract time series from forecasting data.}
\usage{
getFrcEnsem(dataset, cell = "mean", plot = "norm", output = "data",
  name = NULL, mv = 0, coord = NULL, ...)
}
\arguments{
\item{dataset}{A list containing different information, should be the result of \code{\link{loadNcdf}}}

\item{cell}{A vector containing the locaton of the cell, e.g. c(2, 3), default is "mean", representing
the spatially averaged value. Check details for more information.}

\item{plot}{A string showing whether the plot will be shown, e.g., 'norm' means normal plot (without any process), 
'cum' means cummulative plot, default is 'norm'. For other words there will be no plot.}

\item{output}{A string showing which type of output you want. Default is "data", if "ggplot", the 
data that can be directly plotted by ggplot2 will be returned, which is easier for you to make series
plots afterwards. NOTE: If \code{output = 'ggplot'}, the missing value in the data will
be replaced by \code{mv}, if assigned, default mv is 0.}

\item{name}{If \code{output = 'ggplot'}, name has to be assigned to your output, in order to differentiate
different outputs in the later multiplot using \code{getEnsem_comb}.}

\item{mv}{A number showing representing the missing value. When calculating the cumulative value, 
missing value will be replaced by mv, default is 0.}

\item{coord}{A coordinate of longitude and latitude. e.g. corrd = c(lon, lat). If coord is assigned,
cell argument will no longer be used.}

\item{...}{\code{title, x, y} showing the title and x and y axis of the plot. e.g. \code{title = 'aaa'}}
}
\value{
A ensemble time series extracted from forecating data.
}
\description{
getFrcEnsem extract timeseries from forecasting data, if forecasting data has a member session
an ensemble time sereis will be returned, if forecasting data doesn't have a member session, a singe time
series will be returned.
}
\details{
\code{cell} representing the location of the cell, NOTE: this location means the index of the cell,
IT IS NOT THE LONGITUDE AND LATITUDE. e.g., \code{cell = c(2, 3)}, the program will take the 2nd longitude
and 3rd latitude, by the increasing order. Longitude comes first.

\code{name}
Assuming you have two ggplot outputs, you want to plot them together. In this situation, you
need a name column to differentiate one ggplot output from the other. You can assigne this name
by the argument directly, If name is not assigned and \code{output = 'ggplot'} is selected, then
the system time will be selected as name column.
}
\examples{

filePath <- system.file("extdata", "tnc.nc", package = "hyfo")
# Then if you don't know the variable name, you can use \\code{getNcdfVar} to get variable name
varname <- getNcdfVar(filePath)
nc <- loadNcdf(filePath, varname)
a <- getFrcEnsem(nc)

# If there is no member session in the dataset, a single time sereis will be extracted.
a1 <- getFrcEnsem(tgridData)


# The default output is spatially averaged, if there are more than one cells in the dataset, 
# the mean value of the cells will be calculated. While if you are interested in special cell, 
# you can assign the cell value. You can also directly use longitude and latitude to extract 
# time series.

getSpatialMap(nc, 'mean')
a <- getFrcEnsem(nc, cell = c(6,2))

# From the map, cell = c(6, 2) means lon = -1.4, lat = 43.2, so you can use corrd to locate
# your research area and extract time series.
b <- getFrcEnsem(nc, coord = c(-1.4, 43.2))


# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item H. Wickham. ggplot2: elegant graphics for data analysis. Springer New York, 2009.
\item Hadley Wickham (2007). Reshaping Data with the reshape Package. Journal of Statistical Software,
21(12), 1-20. URL http://www.jstatsoft.org/v21/i12/.
\item Santander Meteorology Group (2015). downscaleR: Climate data manipulation and
statistical downscaling. R package version 0.6-0.
https://github.com/SantanderMetGroup/downscaleR/wiki
}
}
