% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manningc.R
\name{manningc}
\alias{manningc}
\title{Solves the Manning Equation for gravity flow in a circular pipe}
\usage{
manningc(
  Q = NULL,
  n = NULL,
  Sf = NULL,
  y = NULL,
  d = NULL,
  y_d = NULL,
  n_var = FALSE,
  units = c("SI", "Eng"),
  ret_units = FALSE
)
}
\arguments{
\item{Q}{numeric vector that contains the flow rate [\eqn{m^3 s^{-1}}{m^3/s} or \eqn{ft^3 s^{-1}}{ft^3/s}]}

\item{n}{numeric vector that contains the Manning roughness coefficient (for full flow or fixed).}

\item{Sf}{numeric vector that contains the slope of the pipe [unitless]}

\item{y}{numeric vector that contains the water depth [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{d}{numeric vector that contains the pipe diameter [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{y_d}{numeric vector that contains the ratio of depth to diameter [unitless]}

\item{n_var}{If set to TRUE the value of n for full flow is adjusted with depth. [Default is FALSE]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package]}

\item{ret_units}{If set to TRUE the value(s) returned are of class \code{units} with
units attached to the value. [Default is FALSE]}
}
\value{
Returns a list including the missing parameter:
\itemize{
  \item Q - flow rate
  \item V - flow velocity
  \item A - cross-sectional area of flow
  \item P - wetted perimeter
  \item R - hydraulic radius (A/P)
  \item y - flow depth
  \item d - pipe diameter
  \item Sf - slope
  \item n - Manning's roughness (for full flow, or as adjusted if n_var is TRUE)
  \item yc - critical depth
  \item Fr - Froude number
  \item Re - Reynolds number
  \item Qf - Full pipe flow rate
}
}
\description{
This function solves the Manning equation for water flow in a circular pipe 
at less than full. Uniform flow conditions are assumed, so that the pipe slope 
is equal to the slope of the water surface and the energy grade line. This is a 
modification of the code prepared by Irucka Embry in his iemisc package.
The iemisc::manningcirc function was adapted here for more limited cases
commonly used in classroom exercises, additional checks were included to ensure
the pipe is flowing less than full, and a cross-section figure is also
available. The iemisc::manningcirc and iemisc::manningcircy functions were
combined into a single function. Manning n supplied is assumed to be that for
full pipe flow; an optional argument may be supplied to account for n varying 
with depth.
}
\details{
The possible applications of this function for solving the Manning equation
for circular pipes are:
\tabular{ll}{
  \strong{Given} \tab \strong{Solve for} \cr
  y_d, Q, Sf, n \tab d \cr
  d, Sf, Q, n \tab y \cr
  y, d, Q, n \tab Sf \cr
  y, d, Sf, n \tab Q \cr
  d, Q, Sf, y \tab n
}

The Manning equation (also known as the Strickler equation) describes flow conditions in
an open channel under uniform flow conditions. It is often expressed as: 
\deqn{Q = A\frac{C}{n}{R}^{\frac{2}{3}}{S_f}^{\frac{1}{2}}}
where \eqn{C} is 1.0 for SI units and 1.49 for Eng (U.S. Customary) units. Critical depth is 
defined by the relation (at critical conditions):
\deqn{\frac{Q^{2}B}{g\,A^{3}}=1}{Q^2B/gA^3=1}
where \eqn{B}{B} is the top width of the water surface. Since B equals zero for a full pipe, critical 
depth is set to the pipe diameter \eqn{d}{d} if the flow \eqn{Q}{Q} exceeds a value that would produce a 
critical flow at \eqn{\frac{y}{d}=0.99}{y/d=0.99}.
}
\examples{

#Solving for flow rate, Q: SI Units
manningc(d = 0.6, n = 0.013, Sf = 1./400., y = 0.24, units = "SI")
#returns 0.1 m3/s

#Solving for Sf, if d=600 mm and pipe is to flow half full
manningc(d = 0.6, Q = 0.17, n = 0.013, y = 0.3, units = "SI")
#returns required slope of 0.003

#Solving for diameter, d when given y_d): Eng (US) units
manningc(Q = 83.5, n = 0.015, Sf = 0.0002, y_d = 0.9, units = "Eng")
#returns 7.0 ft required diameter

#Solving for depth, y when given Q: SI units
manningc(Q=0.01, n=0.013, Sf=0.001, d = 0.2, units="SI")
#returns depth  y = 0.158 m, critical depth, yc = 0.085 m

#Solving for depth, y when given Q: SI units, and n variable with depth
manningc(Q=0.01, n=0.013, Sf=0.001, d = 0.2, n_var = TRUE, units="SI")
#returns depth  y = 0.174 m, critical depth, yc = 0.085 m

}
\seealso{
\code{\link{xc_circle}} for a cross-section diagram of the circular channel
}
\author{
Ed Maurer, Irucka Embry
}
