% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan.R
\name{kfold.hsstan}
\alias{kfold.hsstan}
\alias{kfold}
\title{K-fold cross-validation}
\usage{
\method{kfold}{hsstan}(
  x,
  folds,
  chains = 1,
  store.fits = TRUE,
  cores = getOption("mc.cores", 1),
  ...
)
}
\arguments{
\item{x}{An object of class \code{hsstan}.}

\item{folds}{Integer vector with one element per observation indicating the
cross-validation fold in which the observation should be withdrawn.}

\item{chains}{Number of Markov chains to run. By default this is set to 1,
independently of the number of chains used for \code{x}.}

\item{store.fits}{Whether the fitted models for each fold should be stored
in the returned object (\code{TRUE} by default).}

\item{cores}{Number of cores to use for parallelization (the value of
\code{options("mc.cores")} by default). The cross-validation folds will
be distributed to the available cores, and the Markov chains for each
model will be run sequentially.}

\item{...}{Further arguments passed to \code{\link[rstan]{sampling}}.}
}
\value{
An object with classes \code{kfold} and \code{loo} that has a similar structure as the
objects returned by \code{\link[=loo]{loo()}} and \code{\link[=waic]{waic()}} and is compatible with the
\code{\link[loo]{loo_compare}} function for
comparing models. The object contains the following fields:
\item{estimates}{a matrix containing point estimates and standard errors of
the expected log pointwise predictive density ("elpd_kfold"),
the effective number of parameters ("p_kfold", always \code{NA}) and the
K-fold information criterion "kfoldic" (which is \code{-2 * elpd_kfold},
i.e., converted to the deviance scale).}
\item{pointwise}{a matrix containing the pointwise contributions of
"elpd_kfold", "p_kfold" and "kfoldic".}
\item{fits}{a matrix with two columns and number of rows equal to the number
of cross-validation folds. Column \code{fit} contains the fitted
\code{hsstan} objects for each fold, and column \code{test.idx} contains
the indices of the withdrawn observations for each fold. This is not
present if \code{store.fits=FALSE}.}
\item{data}{the dataset used in fitting the model (before withdrawing
observations). This is not present if \code{store.fits=FALSE}.}
}
\description{
Perform K-fold cross-validation using the same settings used when fitting
the model on the whole data.
}
\examples{
\donttest{
\dontshow{utils::example("hsstan", echo=FALSE)}
# continued from ?hsstan
# only 2 folds for speed of example
folds <- rep(1:2, length.out=length(df$Y))
cv.biom <- kfold(hs.biom, folds=folds, cores=2)
}

}
