% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{plot.projsel}
\alias{plot.projsel}
\title{Plot of relative explanatory power of predictors}
\usage{
\method{plot}{projsel}(x, title = NULL, max.points = NULL,
  max.labels = NULL, from.covariates = TRUE, font.size = 12,
  hadj = 0.05, vadj = 0, ...)
}
\arguments{
\item{x}{A data frame created by \code{\link[=projsel]{projsel()}}.}

\item{title}{Title of the plot. If \code{NULL}, no title is displayed.}

\item{max.points}{Maximum number of predictors to be plotted. If \code{NULL}
(default) or 0, all points are plotted.}

\item{max.labels}{Maximum number of predictors to be labelled. If \code{NULL}
(default), all predictor labels present in \code{x} are displayed, which
may result in overprinting.}

\item{from.covariates}{Whether the plotting should start from the unpenalized
covariates (\code{TRUE} by default). If set to \code{FALSE}, the plot includes a
point for the null (intercept-only) model.}

\item{font.size}{Size of the textual elements (labels and axes).}

\item{hadj, vadj}{Horizontal and vertical adjustment for the labels.}

\item{...}{Currently ignored.}
}
\value{
A \strong{ggplot2} object showing the relative incremental contribution of each
predictor starting from the initial set of unpenalized covariates.
}
\description{
The function plots the relative explanatory power of each predictor in order
of selection. The relative explanatory power of predictors is computed
according to the KL divergence from the full model to each submodel, scaled
in such a way that the baseline model (either the null model or the model
containing only unpenalized covariates) is at 0, while the full model is at 1.
}
