% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingheterogeneity.R
\name{latentIndex}
\alias{latentIndex}
\alias{healthIndex}
\title{Calculate the latent index}
\usage{
latentIndex(model, subset = NULL)

healthIndex(model, subset = NULL)
}
\arguments{
\item{model}{a fitted \code{hopit} model.}

\item{subset}{an optional vector that specifies a subset of observations.}
}
\value{
a vector with a latent index for each individual.
}
\description{
Calculate the latent index from the fitted model. The latent index is a standardized latent measure that takes values from 0 to 1, where
0 refers to the worst predicted state (the maximal observed value for the latent measure) and 1 refers
to the best predicted state (the minimal observed value for the latent measure).
}
\examples{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------

# fit a model
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                  heart_attack_or_stroke + poor_mobility + very_poor_grip +
                  depression + respiratory_problems +
                  IADL_problems + obese + diabetes + other_diseases,
                thresh.formula = ~ sex + ageclass + country,
                decreasing.levels = TRUE,
                control = list(trace = FALSE),
                data = healthsurvey)

# calculate the health index
hi <- latentIndex(model1)

summary(hi)

# plot a simple histogram of the function output
hist(hi, col='deepskyblue3')

#plot the reported health status versus the health index.
plot(hi, response = "data", ylab = 'Health index',
     col='deepskyblue3', main = 'Reported health levels')

# plot the model-predicted health levels versus the health index.
plot(hi, response = "fitted", ylab = 'Health index',
     col='deepskyblue3', main = 'Model-predicted health levels')
}
\references{
\insertRef{Jurges2007}{hopit}\cr\cr
\insertRef{OKSUZYAN2019}{hopit}
}
\seealso{
\code{\link{standardizeCoef}}, \code{\link{getCutPoints}}, \code{\link{getLevels}}, \code{\link{hopit}}.
}
\author{
Maciej J. Danko
}
