% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhm.R
\name{bhm}
\alias{bhm}
\title{Bayesian Heating Model}
\usage{
bhm(formula, data, baseLoad = NULL)
}
\arguments{
\item{formula}{an object of class "\link{formula}": a description of which variable
holds the energy readouts and which variable holds the daily temperatures.}

\item{data}{a data frame in which the energy and daily temperatures are to be found.}

\item{baseLoad}{a optional constant base load, e.g. for domestic hot water preparation.}
}
\value{
\code{bhm} returns an object of \link{class} "\code{bhm}". The generic
accessor functions \code{coefficients}, \code{vcov} and \code{residuals} extract the usual
information from the fitted model, while \code{logposterior} will return a function
that evaluates the log-posterior as a function of the parameters.
}
\description{
Estimates the parameters of a building's heating model.
}
\details{
\code{bhm} assumes that the heating energy for a building has been measured
over several time periods (not necessarily of equal length). The \code{data}
data frame should have one row per measurement period. The energy vector (whose
name is given on the left-hand side of the formula) will have the total energy
measured during each period. The daily temperature vector (whose name is given on 
the right-hand side of the formula) will have either a vector of average daily
temperatures (when each measurement period is just one day) or a list of vectors
(when each measurement period can be an arbitrary number of days).
}
\examples{
set.seed(1111)

# Simple, but unrealistic parameters
K <- 1
tb <- 1
DHW <- 1
sigma <- 1e-2
temps <- tb + c(-2, -1, 0, 1)

# With daily measurements
E <- K * pmax(tb - temps, 0) + DHW + rnorm(length(temps), 0, sigma)
fourDayData <- data.frame(E = E, T = temps)
fourDayData
\dontrun{
fit <- bhm(E ~ T, fourDayData)
coef(fit)
resid(fit)
}

# With two-day measurements
fourTimesTwoDayData <- with(fourDayData,
                            data.frame(E = 2 * E,
                            T = I(lapply(T, function(x) c(x, x)))))
fit2 <- bhm(E ~ T, fourTimesTwoDayData)
coef(fit2)
resid(fit2)
}

