% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mplus_fit.R
\name{Mplus_fit}
\alias{Mplus_fit}
\title{Reading some fit indices from Mplus output}
\usage{
Mplus_fit(target, w = FALSE, ...)
}
\arguments{
\item{target}{name of the Mplus output file - e.g. target = "MyMplus.out" for an Mplus output file in the current workspace directory.}

\item{w}{logical - write fit coefficients as csv table? - default: \code{w = FALSE}.}

\item{...}{additional parameters passed through}
}
\value{
a list containing coefficients for model fit and a '.csv' file in the current workspace directory.
}
\description{
This function reads the fit-indices "ChiSq","df","p","CFI","RMSEA","SRMR" and returns them as a list and writes them (optionally) as a csv file into the current workspace directory.
}
\details{
no details
}
\examples{
## first prepare an Mplus syntax 
data(example2) # loading fictional example correlation matrix
Mplus_esyn(N = 300, Cor = example2)
## !!! now first open the data example2.inp with Mplus and click run !!! 
##### not run until Mplus is installed on your system #####
\dontrun{Mplus_fit("example2.out")}
################################################################
### clean up work directory
file.remove("example2.inp") # remove generated Mplus syntax from work dir.
file.remove("example2.dat") # remove generated cor. data from work dir.
}
\keyword{calculus}
