\name{hnp-package}
\alias{hnp-package}
\docType{package}
\encoding{UTF-8}
\title{Half-Normal Plots with Simulation Envelopes}
\description{Generates (half-)normal plots with simulation envelopes for common diagnostics from fitted models for a range of model classes. The function \code{hnp()} is written so that it is relatively easy to extend it to new model classes and different diagnostics that are not already implemented. A few example datasets are included. The main functions are \code{hnp} and \code{plot.hnp}}
\details{
\tabular{ll}{
Package: \tab hnp\cr
Type: \tab Package\cr
Version: \tab 1.1\cr
Date: \tab 2015-09-03\cr
License: \tab GPL version 2 or newer\cr
}
Package includes two functions, \code{hnp} and \code{plot.hnp}, as well as seven data sets extracted from \enc{Demétrio}{Demetrio} et al (2014).
Explanation on how to produce the half-normal plots with simulation envelopes can be found in \enc{Demétrio}{Demetrio} and Hinde (1997) and on the \code{hnp} function documentation.
Data sets are based on entomology studies and the focus is on overdispersed data. Details on overdispersion models can be found in Hinde and \enc{Demétrio}{Demetrio} (1998).
Special thanks to FAPESP and CNPq for funding.
}
\author{
Rafael A. Moral, John Hinde and Clarice G. B. \enc{Demétrio}{Demetrio}

Maintainer: Rafael Moral <rafael_moral@yahoo.com.br>
}
\references{
Moral, R. A., Hinde, J. and \enc{Demétrio}{Demetrio}, C. G. B. (2017) Half-normal plots and overdispersed models in R: the hnp package. Journal of Statistical Software 81(10):1-23.

\enc{Demétrio}{Demetrio}, C. G. B. and Hinde, J. (1997) Half-normal plots and overdispersion. GLIM Newsletter 27:19-26.

Hinde, J. and \enc{Demétrio}{Demetrio}, C. G. B. (1998) Overdispersion: models and estimation. Computational Statistics and Data Analysis 27:151-170.

\enc{Demétrio}{Demetrio}, C. G. B., Hinde, J. and Moral, R. A. (2014) Models for overdispersed data in entomology. In Godoy, W. A. C. and Ferreira, C. P. (Eds.) Ecological modelling applied to entomology. Springer.
}
\keyword{ package }
