% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setfHMM.R
\name{set_fhmm}
\alias{set_fhmm}
\title{\code{S3} Class for Hidden Markov Models with functional response.}
\usage{
set_fhmm(Obs, bT = NULL, nStates = NULL, nu = 1/rep(nStates,
  nStates), A = matrix(1/nStates, nStates, nStates), centroids = NULL)
}
\arguments{
\item{Obs}{your data, it can be a matrix (multivariate data) or a \code{funData} object (functional data)}

\item{bT}{the vector of the beginning times for the statistical units}

\item{nStates}{an integer representing the number of states of the Hidden Markov Model.}

\item{nu}{a vector of the initial probabilities of the Hidden Markov Model.}

\item{A}{the transition matrix of the Hidden Markov Model.}

\item{centroids}{the initialization of the centers.}
}
\value{
The function returns an object of \code{S3} class \code{fhmm} containing the initialization and the data of your HMM
}
\description{
This function creates an object of \code{S3} class \code{fhmm},
 which contains the elements of a Hidden Markov Model with
 multivariate response whose components can be correlated through a
 gaussian copula.
}
\examples{
\donttest{
data(simulatedFD)
FD <- simulatedFD
n <- 20
n_tot <- dim(FD$data[[1]])[1]
bt <- seq(1, n_tot, by = n)
hmm <- set_fhmm(FD, nStates = 3, bT = bt)}
}
\references{
Rabiner, L. R. (1989). A tutorial on hidden Markov models and selected applications in speech recognition. Proceedings of the IEEE, 77(2), 257-286.
Martino A., Guatteri, G. and Paganoni A. M., Hidden Markov Models for multivariate functional data, MOX Report 21/2019, 2019
}
\seealso{
\code{\link{fitBM_fhmm}}
}
