% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_hilda.R
\name{read_hilda}
\alias{read_hilda}
\title{Read and Combine HILDA waves}
\usage{
read_hilda(domain, waves = NULL, dir = NULL, filenames = NULL)
}
\arguments{
\item{domain}{The domain you want to extract. \code{Domain} refers to the variable prefixes (of any length), excluding any wave indicators. For several domains separate by c("x", "y").}

\item{waves}{The wave(s) you want the domain variables to come from. Can be left empty if using custom file names.}

\item{dir}{Directory where the STATA files are located. Default is the current working directory.}

\item{filenames}{Vector of .dta files to be read. Default is names used by the Australian Data Archive.}
}
\value{
A \code{data.frame} with the chosen \code{domain} variables, xwaveid and wave indicator.
}
\description{
Extracts and combines variables from selected HILDA waves
}
\details{
The \code{read_hilda} function reads, extracts and combines variables from individual waves (a wave refers to each separate survey in a series of related surveys) of the panel dataset
'The Household, Income and Labour Dynamics in Australia' (HILDA), into an R data.frame.
If you are using many waves \code{read_hilda} can take a while to run, go grab a cup of coffee! Don't forget to save the resulting \code{data.frame} so you don't have to do it again.

The identifier \code{xwaveid} is included by default. An indicator \code{wave} is created, keeping track of from which wave a variable originates (denoted by wave prefixes a:q for waves 1:17).
The function reads from the HILDA .dta (STATA) files.
}
\examples{
path <- system.file("extdata", package = "hildareadR")
# Reads variable hibiff and all variables named hgage from waves 1 to 3 in directory fdir
read_hilda(c("hibiff", "hgage"), waves = 1:3, dir = path)
# Reads variable aiopeye from custom files in directory fdir
read_hilda("aiopeye", dir = path, filenames = c("custom1.dta", "custom2.dta"))
}
\author{
Sara Kalucza & Sebastian Kalucza
}
