% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{aggregateTS}
\alias{aggregateTS}
\title{Aggregate a time series}
\usage{
aggregateTS(
  ts,
  FUN = "previoustick",
  alignBy = "minutes",
  alignPeriod = 1,
  weights = NULL,
  dropna = FALSE,
  tz = NULL,
  ...
)
}
\arguments{
\item{ts}{\code{xts} or \code{data.table} object to aggregate.}

\item{FUN}{function to apply over each interval. By default, previous tick aggregation is done. 
Alternatively one can set e.g. FUN = "mean".
In case weights are supplied, this argument is ignored and a weighted average is taken.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. Possible values are: "secs", "seconds", "mins", "minutes", "hours", "days", "weeks", "ticks".}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{weights}{By default, no weighting scheme is used. 
When you assign an \code{xts} object with weights to this argument, a weighted mean is taken over each interval. 
Of course, the weights should have the same time stamps as the supplied time series.}

\item{dropna}{boolean, which determines whether empty intervals should be dropped.
By default, an NA is returned in case an interval is empty, except when the user opts
for previous tick aggregation, by setting \code{FUN = "previoustick"} (default).}

\item{tz}{character denoting which timezone the output should be in. Defaults to \code{NULL}}

\item{...}{extra parameters passed on to \code{FUN}}
}
\value{
An \code{xts} object containing the aggregated time series.
}
\description{
Aggregate a time series as \code{xts} or \code{data.table} object. 
It can handle irregularly spaced time series and returns a regularly spaced one.
Use univariate time series as input for this function and check out \code{\link{aggregateTrades}}
and \code{\link{aggregateQuotes}} to aggregate Trade or Quote data objects.
}
\details{
The time stamps of the new time series are the closing times and/or days of the intervals. 
For example, for a weekly aggregation the new time stamp is the last day in that particular week (namely Sunday).

In case of previous tick aggregation, 
for \code{alignBy} is either \code{"seconds"} \code{"minutes"}, or \code{"hours"},
the element of the returned series with e.g. timestamp 09:35:00 contains 
the last observation up to that point, including the value at 09:35:00 itself.

Please note: In case an interval is empty, by default an NA is returned.. In case e.g. previous 
tick aggregation it makes sense to fill these NAs by the function \code{na.locf}
(last observation carried forward) from the \pkg{zoo} package.

In case \code{alignBy = "ticks"}, the sampling is done such the sampling starts on the first tick and the last tick is always included.
For example, if 14 observations are made on one day, and these are 1, 2, 3, ... 14.
Then, with \code{alignBy = "ticks"} and \code{alignPeriod = 3}, the output will be 1, 4, 7, 10, 13, 14.
}
\examples{
# Load sample price data
\dontrun{
library(xts)
ts <- as.xts(sampleTData[, list(DT, PRICE, SIZE)])

# Previous tick aggregation to the 5-minute sampling frequency:
tsagg5min <- aggregateTS(ts, alignBy = "minutes", alignPeriod = 5)
head(tsagg5min)
# Previous tick aggregation to the 30-second sampling frequency:
tsagg30sec <- aggregateTS(ts, alignBy = "seconds", alignPeriod = 30)
tail(tsagg30sec)
tsagg3ticks <- aggregateTS(ts, alignBy = "ticks", alignPeriod = 3)
}


}
\author{
Jonathan Cornelissen, Kris Boudt, and Emil Sjoerup.
}
\keyword{data}
\keyword{manipulation}
