% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plink.r
\name{read_plink}
\alias{read_plink}
\title{data load}
\usage{
read_plink(
  bfile = "",
  maxLine = 10000,
  impute = TRUE,
  mode = c("A", "D"),
  out = NULL,
  threads = 4
)
}
\arguments{
\item{bfile}{character, prefix of Plink binary format data.}

\item{maxLine}{number, set the number of lines to read at a time.}

\item{impute}{logical, whether to impute missing values in genotype by major alleles.}

\item{mode}{"A" or "D", additive effect or dominant effect.}

\item{out}{character, path and prefix of output file}

\item{threads}{number, the number of used threads for parallel process}
}
\value{
hibayes will code the genotype A1A1 as 2, A1A2 as 1, and A2A2 as 0, where A1 is the first allele of each marker in *.bim file, therefore the estimated effect size is on A1 allele, users should pay attention to it when a process involves marker effect.
}
\description{
To load plink binary data
}
\examples{
bfile_path = system.file("extdata", "geno", package = "hibayes")
data = read_plink(bfile_path, out=tempfile(), mode="A")
fam = data$fam
geno = data$geno
map = data$map
}
