% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgwr.R
\name{hgwr}
\alias{hgwr}
\title{Hierarchical and Geographically Weighted Regression}
\usage{
hgwr(
  formula,
  data,
  local.fixed,
  coords,
  bw,
  kernel = c("gaussian", "bisquared"),
  alpha = 0.01,
  eps_iter = 1e-06,
  eps_gradient = 1e-06,
  max_iters = 1e+06,
  max_retries = 10,
  ml_type = c("D_Only", "D_Beta"),
  verbose = 0
)
}
\arguments{
\item{formula}{A formula.
Its structure is similar to \code{\link[lme4]{lmer}} function
in \strong{lme4} package.}

\item{data}{A DataFrame.}

\item{local.fixed}{A character vector.
It contains names of local fixed effects.}

\item{coords}{A 2-column matrix.
It consists of coordinates for each group.}

\item{bw}{A numeric value. It is the value of bandwidth.
In this stage this function only support adaptive bandwidth.
And its unit must be the number of nearest neighbours.}

\item{kernel}{A character value. It specify which kernel function is used
in GWR part. Possible values are
\describe{
\item{\code{gaussian}}{Gaussian kernel function \eqn{k(d)=\exp\left(-\frac{d^2}{b^2}\right)}}
\item{\code{bisquared}}{Bi-squared kernel function. If \eqn{d<b} then \eqn{k(d)=\left(1-\frac{d^2}{b^2}\right)^2} else \eqn{k(d)=0}}
}}

\item{alpha}{A numeric value. It is the size of the first trial step in
maximum likelihood algorithm.}

\item{eps_iter}{A numeric value. Terminate threshold of back-fitting.}

\item{eps_gradient}{A numeric value. Terminate threshold of
maximum likelihood algorithm.}

\item{max_iters}{An integer value. The maximum of iteration.}

\item{max_retries}{An integer value. If the algorithm tends to be diverge,
it stops automatically after trying \emph{max_retires} times.}

\item{ml_type}{An integer value. Represent which maximum likelihood
algorithm is used. Possible values are:
\describe{
\item{\code{D_Only}}{Only \eqn{D} is specified by maximum likelihood.}
\item{\code{D_Beta}}{Both \eqn{D} and \eqn{beta} is specified by maximum likelihood.}
}}

\item{verbose}{An integer value. Determine the log level.
Possible values are:
\describe{
\item{0}{no log is printed.}
\item{1}{only logs in back-fitting are printed.}
\item{2}{all logs are printed.}
}}
}
\value{
A list describing the model with following fields.
\describe{
\item{\code{gamma}}{Coefficients of local fixed effects.}
\item{\code{beta}}{Coefficients of global fixed effects.}
\item{\code{mu}}{Coefficients of random effects.}
\item{\code{D}}{Variance-covariance matrix of random effects.}
\item{\code{sigma}}{Variance of errors.}
\item{\code{effects}}{A list including names of all effects.}
\item{\code{call}}{Calling of this function.}
\item{\code{frame}}{The DataFrame object sent to this call.}
\item{\code{frame.parsed}}{Variables extracted from the data.}
\item{\code{groups}}{Unique group labels extracted from the data.}
}
}
\description{
A Hierarchical Linear Model (HLM) with local fixed effects.
}
\examples{
data(multisampling)
hgwr(formula = y ~ g1 + g2 + x1 + (z1 | group),
     data = multisampling$data,
     local.fixed = c("g1", "g2"),
     coords = multisampling$coords,
     bw = 10)

}
