% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combining.R
\name{unifont_combining}
\alias{unifont_combining}
\title{Get combining character code points}
\usage{
unifont_combining(upper = TRUE, csur = TRUE, unicode = FALSE)
}
\arguments{
\item{upper}{Include glyphs above the Unicode Basic Multilingual plane.}

\item{csur}{Include (Under-)Conscript Unicode Registry glyphs.}

\item{unicode}{Include combining glyphs assigned by the Unicode Consortium
(i.e. not ones in the Private Use Area like the CSUR ones).
By default \code{FALSE} since \code{\link[bittermelon:bm_compose]{bittermelon::bm_compose()}} can usually guess that
a Unicode Consortium assigned glyph is a combining glyph by
using \code{\link[Unicode:u_char_properties]{Unicode::u_char_property()}}.}
}
\value{
A character vector of Unicode code points
}
\description{
\code{unifont_combining()} returns a character vector of the code points
for all the "combining" characters in Unifont.
}
\examples{
uc <- unifont_combining()
print(uc)

# Tengwar with combining glyphs
if (require("bittermelon")) {
  s <- "\ue004\ue014\ue04a\ue005\ue000\ue040\ue022\ue04a\ue003\ue04e"
  font <- unifont(ucp = str2ucp(s))
  bml <- as_bm_list(s, font = font)
  to_raise <- which(names(bml) \%in\% c("U+E04A", "U+E04E"))
  bml[to_raise] <- bm_shift(bml[to_raise], top = 1L)
  bml <- bm_compose(bml, pua_combining = uc)
  bml <- bm_pad(bml, type = "trim", left = 1L, right = 0L)
  bm <- bm_call(bml, cbind)
  print(bm, px = px_ascii)
}
}
\seealso{
Can be used with the \code{pua_combining} argument of \code{\link[bittermelon:bm_compose]{bittermelon::bm_compose()}}
and \code{\link[bittermelon:as_bm_bitmap]{bittermelon::as_bm_bitmap()}}.
}
