% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{set_covariates}
\alias{set_covariates}
\alias{set_covariates_}
\title{Set Covariates of a Survival Distribution}
\usage{
set_covariates(dist, ..., data = NULL)

set_covariates_(dist, covariates, data = NULL)
}
\arguments{
\item{dist}{a survfit or flexsurvreg object}

\item{...}{Covariate values representing the group for
which survival probabilities will be generated when
evaluated.}

\item{data}{A an optional data frame representing
multiple sets of covariate values for which survival
probabilities will be generated. Can be used to
generate aggregate survival for a heterogeneous set of
subjects.}

\item{covariates}{Used to work around non-standard
evaluation.}
}
\value{
A \code{surv_model} object.
}
\description{
Set the covariate levels of a survival model to be
represented in survival projections.
}
\examples{

fs1 <- flexsurv::flexsurvreg(
  survival::Surv(rectime, censrec)~group,
  data=flexsurv::bc,
  dist = "llogis"
)
good_model <- set_covariates(fs1, group = "Good")
cohort <- data.frame(group=c("Good", "Good", "Medium", "Poor"))
mixed_model <- set_covariates(fs1, data = cohort)

}
