% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newdata.R
\name{run_newdata}
\alias{run_newdata}
\title{Iteratively Run Markov Models Over New Parameter Sets 
(Heterogeneity or Probabilistic analysis)}
\usage{
run_newdata(..., init, cycles, newdata)
}
\arguments{
\item{...}{Either one or more unevaluated Markov models, 
or the result of \code{\link{run_models}}.}

\item{init}{Initial number of individual per state. Not 
needed when working on \code{\link{run_models}} 
results.}

\item{cycles}{Number of Markov cycles to compute. Not 
needed when working on \code{\link{run_models}} 
results.}

\item{newdata}{A data.frame of new parameter sets, one 
column per parameter and one row per parameter set. Can
be prespecified for heterogeneity analysis or randomly 
drawn with resample for probability analysis.}
}
\value{
A list with one data.frame per model.
}
\description{
Given a table of new parameter values with a new 
parameter set per line, runs iteratively Markov odels 
over these sets.
}
\examples{
# running a single model

mod1 <-
  define_model(
    parameters = define_parameters(
      age_init = 60,
      age = age_init + markov_cycle
    ),
    transition_matrix = define_matrix(
      .5, .5,
      .1, .9
    ),
    states = define_state_list(
      define_state(
        cost = 543 + age * 5
      ),
      define_state(
        cost = 432 + age
      )
    )
  )

# running several models
mod2 <-
  define_model(
    parameters = define_parameters(
      age_init = 60,
      age = age_init + markov_cycle
    ),
    transition_matrix = define_matrix(
      .5, .5,
      .1, .9
    ),
    states = define_state_list(
      define_state(
        cost = 789 * age / 10
      ),
      define_state(
        cost = 456 * age / 10
      )
    )
  )

res2 <- run_model(
  mod1, mod2,
  init = 1:0,
  cycles = 10
)
# generating table with new parameter sets
new_tab <- data.frame(
  age = 40:80
)

# with run_model result
ndt1 <- run_newdata(res2, newdata = new_tab)

# with uneval models
ndt2 <- run_newdata(
  A = mod1, B = mod2,
  init = 1:0, cycles = 10,
  newdata = new_tab)

identical(ndt1, ndt2)
}

